 ; Ŀ
 ;   Blam: explode blocks neatly.                                          
 ;   Replace attributes with text, move entities on layer 0 to the layer   
 ;   the block was on, set colour and linetype to those of the original    
 ;   block for subentities which were coloured and linetyped byblock.      
 ;   Currently deletes invisible attributes - see (txmake).                
 ;   Copyright 1991, 1995, 1999, 2005, 2008, 2009 by Rocket Software Ltd.  
 ;   Another subversive program from Rocket.                               
 ; 

 ; Ŀ
 ;   Subroutine Newent - deal with entities created by Txmake or by        
 ;   exploding the block.  Erase Attdefs and empty text strings, redraw    
 ;   other text (which will have been messed up when the attribute under   
 ;   it was erased), move any entities on layer 0 to the current layer     
 ;   and change any coloured or linetyped entities.                        
 ;   Arguments: Aa, the last entity before the block was exploded.         
 ;              Blay, the layer containin the original block.              
 ;              Bcol, the colour of the original block.                    
 ;              Blt, the linetype of the original block.                   
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN NEWENT (aa blay bcol blt / ss del aaa clr vall)
  (setq del 0)                                 ; empty string counter
  (setq ss (ssadd))                            ; text selection set for redraw
  (while (setq aa (entnext aa))                ; while there is another entity
         (setq aaa (entget aa))                ; get its data
 ; Ŀ
 ;   If the entity was on layer 0, move it to the layer the block was on.  
 ; 
         (if (= (cdr (assoc 8 aaa)) "0")
             (progn
                  (entmod (setq aaa (subst (cons 8 blay) (assoc 8 aaa) aaa)))
                  (setq aaa (entget aa))))
 ; Ŀ
 ;   If the entity was linetyped byblock, change it to the block linetype  
 ;   if there was one, else to bylayer.                                    
 ; 
         (if (and (setq ltyp (assoc 6 aaa))
                  (= (strcase (cdr ltyp) t) "byblock"))
             (progn
                  (if blt
                      (entmod (setq aaa (subst (cons 6 blt) ltyp aaa)))
                      (entmod (setq aaa (subst (cons 6 "bylayer") ltyp aaa))))
                  (setq aaa (entget aa))))
 ; Ŀ
 ;   If the entity was coloured byblock, change it to the block colour     
 ;   if there was one, else to bylayer.                                    
 ; 
         (if (= (cdr (setq clr (assoc 62 aaa))) 0)
             (progn
                  (if bcol
                      (entmod (setq aaa (subst (cons 62 bcol) clr aaa)))
                      (entmod (setq aaa (subst (cons 62 256) clr aaa))))
                  (setq aaa (entget aa))))
 ; Ŀ
 ;   If the entity was an attdef, erase it.                                
 ; 
         (cond ((= (cdr (assoc 0 aaa)) "ATTDEF")
                (entdel aa))
 ; Ŀ
 ;   If the entity was an empty text string, erase it.                     
 ; 
               ((= (cdr (assoc 0 aaa)) "TEXT")
                (setq vall (cdr (assoc 1 (entget aa))))
                (if (member vall '("" " " "  "))
                    (progn
                         (setq del (1+ del))
                         (entdel aa))
                    (ssadd aa ss)))))
 ; Ŀ
 ;   Redraw the selection set.                                             
 ; 
  (while (setq aa (ssname ss 0))
         (redraw aa)
         (ssdel aa ss))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (cond ((= 1 del)
         (write-line "\n1 vacant text string erased."))
        ((< 1 del)
         (write-line (strcat "\n" (itoa del)
                             " empty text strings eradicated."))))
 (princ))
 ; Ŀ
 ;   Newent end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Txmake - duplicate attributes with text entities.          
 ;   Arguments: Blenam, the attribute entity name.                         
 ;              Kilinv, if t then erase invisible attributes.              
 ;   Calls nothing, returns nothing, collects barnacles.                   
 ; 
 (DEFUN TXMAKE (blenam kilinv / conv tt fh bb nn elast bbf sublst asonum)
  (setq conv 0)
  (setq tt (getvar "textstyle"))                         ; current text style
  (setq fh (cdr (assoc 40 (tblsearch "style" tt))))      ; is it fixed height?
  (while (/= (cdr (assoc 0 (setq bb 
             (entget (setq blenam (entnext blenam)))))) "SEQEND")
         (if (not (and kilinv (= 1 (logand 1 (cdr (assoc 70 bb))))))
             (progn
                  (setq conv (1+ conv))
                  (setq nn 2)
                  (if (= fh 0.0)                                ; fixed height?
                      (command "text" (getvar "viewctr") "" "" ".")  ; no
                      (command "text" (getvar "viewctr") "" "."))    ; yes
                  (setq elast (entget (entlast)))
                  (setq bbf (list (nth 1 elast) (nth 0 elast)))
                  (while (setq sublst (nth nn bb))
                         (setq asonum (car sublst))
                         (cond ((not (or (= 3 asonum)
                                         (= 5 asonum)
                                         (= 2 asonum)
                                         (= 70 asonum)
                                         (= 73 asonum)
                                         (= 74 asonum)
                                         (= 280 asonum)))
                                (setq bbf (cons sublst bbf)))
                               ((= 74 asonum)
                                (setq bbf (cons (cons 73 (cdr sublst)) bbf))))
                         (setq nn (1+ nn)))
                  (setq bbf (reverse bbf))
                  (entmod bbf))))
 ; Ŀ
 ;   Print summary of actions.                                             
 ; 
  (if (> conv 1)
      (prompt (strcat "\n" (itoa conv) " attributes converted"))
      (prompt (strcat "\n1 attribute rationalised")))
 (princ))
 ; Ŀ
 ;   Txmake end.                                                           
 ; 

 ; Ŀ
 ;   Blam - the forebrain.                                                 
 ; 
 (DEFUN C:BLAM (/ ss num bbn bb blay bcol blt aa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq ss (ssget))
  (setq num 0)
  (while (and ss (setq bbn (ssname ss num)))
         (setq bb (entget bbn))
         (if (= (cdr (assoc 0 bb)) "INSERT")
             (progn                                   ; if it's a block
                  (setq blay (cdr (assoc 8 bb)))      ; block layer
                  (setq bcol (cdr (assoc 62 bb)))     ; block colour
                  (setq blt (cdr (assoc 6 bb)))       ; block linetype
 ; Ŀ
 ;   If block has attributes call Txmake to replace them with text.        
 ; 
                  (setq aa (entlast))                 ; save last ename
                  (if (assoc 66 bb) (txmake bbn t))
                  (command ".explode" bbn)            ; explode the block
                  (newent aa blay bcol blt)))         ; deal with new entities
         (setq num (1+ num)))
  (command "undo" "end")
 (princ))